/*
 * @(#)UIDefaultsInspector.java 1.1.1  2005-06-19
 *
 * Copyright (c) 2001 Werner Randelshofer
 * Staldenmattweg 2, Immensee, CH-6405, Switzerland.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * Werner Randelshofer. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Werner Randelshofer.
 */

package ch.randelshofer.debug;

//import ch.randelshofer.gui.table.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.table.*;
/**
 * Displays the current user interface defaults.
 *
 * @author  Werner Randelshofer
 * @version 1.1.1 2005-06-19 LookAndFeel must be initialized before we can get
 * the defaults from it.
 * <br>1.1 2003-03-16 Creates lazy values to show their contents.
 * <br>1.0 2003-03-15 Created.
 */
public class UIDefaultsInspector extends javax.swing.JPanel {
    
    /** Creates new form UIDefaultsInspector */
    public UIDefaultsInspector() {
        initComponents();
        
        UIManager.LookAndFeelInfo[] lafInfos = UIManager.getInstalledLookAndFeels();
        LookAndFeel laf = UIManager.getLookAndFeel();
        UIManager.LookAndFeelInfo currentLafInfo = null;
        for (int i=0; i < lafInfos.length; i++) {
            if (lafInfos[i].getClassName().equals(laf.getClass().getName())) {
                currentLafInfo = lafInfos[i];
                break;
            }
        }
        if (currentLafInfo == null) {
            currentLafInfo = new UIManager.LookAndFeelInfo(laf.getName(), laf.getClass().getName());
            UIManager.LookAndFeelInfo[] temp = new UIManager.LookAndFeelInfo[lafInfos.length + 1];
            System.arraycopy(lafInfos, 0, temp, 1, lafInfos.length);
            temp[0] = currentLafInfo;
            lafInfos = temp;
        }
        DefaultComboBoxModel lafComboBoxModel = new DefaultComboBoxModel(lafInfos);
        lafComboBoxModel.setSelectedItem(currentLafInfo);
        lafComboBox.setModel(lafComboBoxModel);
        lafComboBox.setRenderer(new DefaultListCellRenderer() {
            public Component getListCellRendererComponent(JList list,
            Object value,
            int index,
            boolean isSelected,
            boolean cellHasFocus) {
                if (value != null && (value instanceof UIManager.LookAndFeelInfo)) {
                    value = ((UIManager.LookAndFeelInfo) value).getName();
                    if (value == null) value = "unnamed LAF";
                }
                return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
        });
        
        table.setModel(new UIDefaultsTableModel(UIManager.getLookAndFeelDefaults()));
        //table.setModel(new UIDefaultsTableModel(UIManager.getDefaults()));
        UIDefaultsCellRenderer r = new UIDefaultsCellRenderer();
        r.setFont(new Font("Dialog", Font.PLAIN, 22));
        table.getColumnModel().getColumn(0).setCellRenderer(r);
        table.getColumnModel().getColumn(1).setCellRenderer(r);
    }
    
    public static void main(String[] args) {
        JFrame f = new JFrame("UI Defaults Inspector");
        f.addWindowListener(new WindowAdapter() { public void windowClosing(WindowEvent evt) { System.exit(0); } } );
        f.getContentPane().add(new UIDefaultsInspector());
        f.setSize(400, 300);
        f.show();
    }
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        scrollPane = new javax.swing.JScrollPane();
        table = new javax.swing.JTable();
        jPanel1 = new javax.swing.JPanel();
        lafLabel = new javax.swing.JLabel();
        lafComboBox = new javax.swing.JComboBox();

        setLayout(new java.awt.BorderLayout());

        scrollPane.setFont(new java.awt.Font("Dialog", 0, 11));
        table.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null}
            },
            new String [] {
                "Title 1", "Title 2", "Title 3", "Title 4"
            }
        ));
        scrollPane.setViewportView(table);

        add(scrollPane, java.awt.BorderLayout.CENTER);

        jPanel1.setLayout(new java.awt.GridBagLayout());

        jPanel1.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(6, 12, 6, 12)));
        lafLabel.setText("Look And Feel:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel1.add(lafLabel, gridBagConstraints);

        lafComboBox.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                lafItemChanged(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 12, 0, 0);
        jPanel1.add(lafComboBox, gridBagConstraints);

        add(jPanel1, java.awt.BorderLayout.NORTH);

    }//GEN-END:initComponents
    
    private void lafItemChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_lafItemChanged
        UIManager.LookAndFeelInfo lafInfo = (UIManager.LookAndFeelInfo) lafComboBox.getSelectedItem();
        try {
            LookAndFeel laf = (LookAndFeel) Class.forName(lafInfo.getClassName()).newInstance();
            UIDefaultsTableModel m = (UIDefaultsTableModel) table.getModel();
            laf.initialize();
            m.setUIDefaults(laf.getDefaults());
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        } catch (InstantiationException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        
        
    }//GEN-LAST:event_lafItemChanged
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel jPanel1;
    private javax.swing.JComboBox lafComboBox;
    private javax.swing.JLabel lafLabel;
    private javax.swing.JScrollPane scrollPane;
    private javax.swing.JTable table;
    // End of variables declaration//GEN-END:variables
    
}
